function [kx, ky] = select_kvalues(geom, Ny)

ka = 4*pi/(Ny*geom.mech.amech*sqrt(3));

% Brillouin zone boundary
bz_x = 2*pi/(3*geom.mech.amech)*[-1 -2 -1 1 2 1 -1];
bz_y = 2*pi/(sqrt(3)*geom.mech.amech)*[-1 0 1 1 0 -1 -1];

% Origin for deciding the k values 
% (M point on the bottom side of brillouin zone)
kx_orig = 0;
ky_orig = -2*pi/(sqrt(3)*geom.mech.amech);

% Values on the lattice inside brillouin zone
count = 1;
for j=1:2*Ny-1
    ky(count) = ky_orig + (j-1)*ka/2;
    if rem(j,2)==0
        kx(count) = kx_orig + ka*sqrt(3)/2;
    else
        kx(count) = kx_orig;
    end
    count = count + 1;
    
    for i=1:50
        ky(count) = ky(count-1);
        
        temp_x = kx(count-1) + ka*sqrt(3);
        check_in = inpolygon(temp_x, ky(count-1), bz_x, bz_y);
        
        if check_in==1
            kx(count) = temp_x;
            count = count + 1;
        end
    end
end

figure(2)
hold on;

for i=1:size(kx, 2)
    plot(kx(i), ky(i), 'Color', 'blue', 'LineStyle', 'none',...
        'Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 10);
end

plot(bz_x, bz_y);

end